#include <amxmodx>
#include <amxmisc>
#include <cstrike>

#define PLUGIN	"[POST] MESSAGE TYPE"
#define VERSION	"2.0"
#define AUTHOR	"tuty"

#define ADVERTISE_TIME	10.0

new gPluginOn;
new gAvertise;
new gMessageCost;
new gMessageSayText;
new gMaxPlayers;

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	gPluginOn = register_cvar("amx_postmessage", "1"); 		// 0 - disabled | 1 - enabled
	gAvertise = register_cvar("amx_postmessage_avertise", "1");	// enable advertise message in putinserver
	gMessageCost = register_cvar("amx_postmessage_cost", "10"); 	// post message cost
	gMessageSayText = get_user_msgid("SayText");
	gMaxPlayers = get_maxplayers();
	register_clcmd("say", "hook_say_cmd");
	register_clcmd("say_team", "hook_say_cmd");
	register_dictionary("postmessage.txt");
}
public client_putinserver(id)
{
	if(get_pcvar_num(gAvertise) == 1)
	{
		set_task(ADVERTISE_TIME, "show_message", id);
	}
}
public hook_say_cmd(id)
{
	new check_prefix[6];
	read_argv(1, check_prefix, 5);
	
	if(!equal(check_prefix, "/post " "/POST", 5))
		return PLUGIN_CONTINUE;
		
	if(!get_pcvar_num(gPluginOn))
	{
		client_print(id, print_chat, "%L", id, "MESSAGE_DISABLED");
		return PLUGIN_HANDLED;
	}
	new said[256], name[32];
	read_args(said, 255);  
	remove_quotes(said);
	trim(said);
	replace(said, 255, check_prefix, ""); 
	
	get_user_name(id, name , 31); 
	if(!is_user_alive(id))
	{
		client_print(id, print_chat, "%L", id, "NOT_ALIVE");
		return PLUGIN_HANDLED;
	}
	new money = cs_get_user_money(id);
	new cost = get_pcvar_num(gMessageCost);
	if(money < cost)
	{
		client_print(id, print_chat, "%L", id, "DONT_HAVE_MONEY");
		return PLUGIN_HANDLED;
	}
	color_print(0, "^x01[%s]^x04 [ %s ]: [ %s ]", (get_user_team(id) == 1) ? "T" : "CT" , name, said);
	cs_set_user_money(id, money - cost);
	return PLUGIN_HANDLED;
}
public show_message(id)
{
	client_print(id, print_chat, "%L", id, "ADVERTISE_MESSAGE");
	client_print(id, print_chat, "%L", id, "ADVERTISE_MESSAGE2", get_pcvar_num(gMessageCost));
	console_print(id, "%L", id, "ADVERTISE_MESSAGE");
	console_print(id, "%L", id, "ADVERTISE_MESSAGE2", get_pcvar_num(gMessageCost));
}
color_print(id, const message[], {Float,Sql,Result,_}:...)
{
  	 new Buffer[128],Buffer2[128];
 	 formatex(Buffer2, sizeof Buffer2 - 1, "%s", message);
 	 vformat(Buffer, sizeof Buffer - 1, Buffer2, 3);
 	 if(id)
 	 {
     		message_begin(MSG_ONE_UNRELIABLE, gMessageSayText, _, id);
    		write_byte(id);
     		write_string(Buffer);
      		message_end();
   	 }
  	 else
	 {
     		for(new i = 1; i <= gMaxPlayers; i++)
      		{

         		if(!is_user_connected(i))
            			continue;
				
         		message_begin(MSG_ONE_UNRELIABLE, gMessageSayText, _, i);
         		write_byte(i);
         		write_string(Buffer);
         		message_end();
     		}
   	 }
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1033\\ f0\\ fs16 \n\\ par }
*/
