/*
 *
 * WillyumYum - Sniper Control
 * (c) 2004-2005
 *
 * Sniper Rifle Restriction
 * Based off of JustinHoMi's Awp Limit
 * and OLO's Awp Control.
 *
 * Special thanks to BAILOPAN
 * for some helpful 'flag' tips.
 *
 * Special thanks to AssKicR for
 * pointing out hardcoding issues
 *
 *
 */

#include <amxmodx>
#include <amxmisc>
#include <engine>

#pragma semicolon                1      // force ; usage, just 'cause

#define INCLUDE_SCOUT            1      // Include scouts in sniper rifle

new g_szTitle[]   = "Sniper Rifle Control";
new g_szVersion[] = "1.2";
new g_szAuthor[]  = "WillyumYum";

new g_iSniperNum[3];                    // number of sniper rifles per team

new bool:g_bHasSniper[33];              // bool - true if player has a sniper rifle

new g_szWarn[]    = "Sniper rifle limit reached for your team!";

new const SNIPERMODELS[4][] =
{
    #if ( INCLUDE_SCOUT )
    "models/w_scout.mdl",               // CSW_SCOUT
    #else
    "",
    #endif
    "models/w_sg550.mdl",               // CSW_SG550
    "models/w_awp.mdl",                 // CSW_AWP
    "models/w_g3sg1.mdl"                // CSW_G3SG1
};

// Map disabled - original code by Ryan

public bool:Map_Disabled() {

    new szDisabledFile[64];
    get_configsdir( szDisabledFile, 63 );
    format( szDisabledFile, 63, "%s/sc_disabled_maps.cfg", szDisabledFile );

    if ( file_exists( szDisabledFile ) )
    {
        new iLineNum, szData[64], iTextLen;

        while ( read_file( szDisabledFile, iLineNum, szData, 63, iTextLen ) )
        {
            new szMapName[64], szDisabledName[64];

            get_mapname( szMapName, 63 );
            new iLen = copyc( szDisabledName, 63, szData, '*' );

            if ( equali( szMapName, szDisabledName, iLen ) )
                return true;

            iLineNum++;
        }
    }

    return false;
}

public menuSniper( id, key ) {

    if ( !get_cvar_num( "mp_sniper_control" ) )
        return PLUGIN_CONTINUE;

    new iTeam = get_user_team( id );

    if ( iTeam == 1 && ( g_iSniperNum[iTeam] < get_cvar_num( "sc_max_snipers_t" ) || g_bHasSniper[id] ) )       // TERRORIST
        return PLUGIN_CONTINUE;
    else
    if ( iTeam == 2 && ( g_iSniperNum[iTeam] < get_cvar_num( "sc_max_snipers_ct" ) || g_bHasSniper[id] ) )       // COUNTER-TERRORIST
        return PLUGIN_CONTINUE;

    if( iTeam == 1 && key == 1 )  // Allows T's tp buy ak-47, but blocks CT's from buying scout
        return PLUGIN_CONTINUE;
    else
    if( iTeam == 2 && key == 2 )  // Allows CT's to buy m4, but blocks T's from buying scout
        return PLUGIN_CONTINUE;

    engclient_cmd( id, "menuselect" ,"10");
    client_print( id, print_center , g_szWarn );

    return PLUGIN_HANDLED;
}

public bool:check_primary( id ) {

    new iWeapons[32];
    new iTotalWeapons = 0;
    get_user_weapons( id, iWeapons, iTotalWeapons );

    for ( new i = 0; i < iTotalWeapons; i++ )
    {
        switch ( iWeapons[i] )
        {
            case CSW_M3:      return true;
            case CSW_XM1014:  return true;
            case CSW_MP5NAVY: return true;
            case CSW_TMP:     return true;
            case CSW_P90:     return true;
            case CSW_MAC10:   return true;
            case CSW_UMP45:   return true;
            case CSW_AK47:    return true;
            case CSW_SG552:   return true;
            case CSW_GALI:    return true;
            case CSW_FAMAS:   return true;
            case CSW_M4A1:    return true;
            case CSW_AUG:     return true;
            case CSW_SCOUT:   return true;
            case CSW_AWP:     return true;
            case CSW_G3SG1:   return true;
            case CSW_SG550:   return true;
            case CSW_M249:    return true;
        }
    }
    return false;
}

public bool:check_sniper( id ) {

    new iWeapons[32];
    new iTotalWeapons = 0;
    get_user_weapons( id, iWeapons, iTotalWeapons );

    for ( new i = 0; i < iTotalWeapons; i++ )
    {
        switch ( iWeapons[i] )
        {
            #if ( INCLUDE_SCOUT )
            case CSW_SCOUT:   return true;
            #else
            case CSW_SCOUT:   return false;
            #endif

            case CSW_AWP:     return true;
            case CSW_G3SG1:   return true;
            case CSW_SG550:   return true;
        }
    }
    return false;
}

public vexd_pfntouch(pToucher, pTouched) {

    if ( !get_cvar_num( "mp_sniper_control" ) )
        return PLUGIN_CONTINUE;

    new iTouchId   = pToucher;
    new iPlayerId  = pTouched;

    if ( iPlayerId < 0 || iPlayerId > 32 || !is_user_alive( iPlayerId ) )
        return PLUGIN_CONTINUE;

    new szClassName[32];
    entity_get_string( iTouchId, EV_SZ_classname, szClassName, 31 );

    if ( equal( szClassName, "weaponbox" ) )        // a dropped or already 'fired' weapon
    {
        new szGunModel[32];
        entity_get_string( iTouchId, EV_SZ_model, szGunModel, 31 );

        new bool:bHasPrimaryWeapon = check_primary( iPlayerId );

        for ( new i = 0; i < 4; i++ )
        {
            if ( get_entity_flags( iTouchId ) & FL_ONGROUND && !bHasPrimaryWeapon && equal( szGunModel, SNIPERMODELS[i] ) )
            {
                set_entity_flags( iTouchId, FL_ONGROUND, 0 );

                new iTeam = get_user_team( iPlayerId );

                if ( iTeam == 1 )   // TERRORIST
                {
                    if ( g_iSniperNum[iTeam] < get_cvar_num( "sc_max_snipers_t" ) )
                    {
                        set_entity_flags( iTouchId, FL_ONGROUND, 1 );
                    }
                    else
                    {
                        client_print( iPlayerId, print_center , g_szWarn );
                    }
                }
                else
                if ( iTeam == 2 )   // COUNTER-TERRORIST
                {
                    if ( g_iSniperNum[iTeam] < get_cvar_num( "sc_max_snipers_ct" ) )
                    {
                        set_entity_flags( iTouchId, FL_ONGROUND, 1 );
                    }
                    else
                    {
                        client_print( iPlayerId, print_center , g_szWarn );
                    }
                }
                break;
            }
        }
    }
    return PLUGIN_CONTINUE;
}

public cmdDrop( id ) {

    if ( !get_cvar_num( "mp_sniper_control" ) )
        return PLUGIN_CONTINUE;

    new iTeam = get_user_team( id );

    new iAmmo, iClip;
    new iWeap = get_user_weapon( id, iAmmo, iClip );

    if ( check_sniper( id ) && ( iWeap == CSW_AWP || iWeap == CSW_G3SG1 || iWeap == CSW_SG550 ) )
    {
        g_bHasSniper[id] = false;
        --g_iSniperNum[iTeam];

    }
    #if ( INCLUDE_SCOUT )

    else
    if( check_sniper( id ) && iWeap == CSW_SCOUT  )
    {
        g_bHasSniper[id] = false;
        --g_iSniperNum[iTeam];
    }

    #endif

    return PLUGIN_CONTINUE;
}

public evPickUp( id ) {

    if ( !get_cvar_num( "mp_sniper_control" ) )
        return PLUGIN_CONTINUE;

    new iTeam = get_user_team( id );

    if( check_sniper( id ) && !g_bHasSniper[id] )
    {
        g_bHasSniper[id] = true;
        ++g_iSniperNum[iTeam];
    }

    if ( g_bHasSniper[id] && !check_sniper( id ) )
    {
        // Has a primary weapon and HAD sniper, but bought new non-sniper rifle weapon ( no drop event )

        g_bHasSniper[id] = false;
        --g_iSniperNum[iTeam];
    }

    return PLUGIN_CONTINUE;
}

public evRestartRound() {

    if ( !get_cvar_num( "mp_sniper_control" ) )
        return PLUGIN_CONTINUE;

    g_iSniperNum[0] = g_iSniperNum[1] = g_iSniperNum[2]    = 0;

    for(new a = 1; a < 33; ++a)
        g_bHasSniper[a] = false;

    return PLUGIN_CONTINUE;
}

public sc_remove_data( id ) {

    new iTeam = get_user_team( id );

    if ( g_bHasSniper[id] )
    {
        g_bHasSniper[id] = false;
        --g_iSniperNum[iTeam];
    }

    return PLUGIN_CONTINUE;
}

public client_disconnect( id ) {

    if ( !get_cvar_num( "mp_sniper_control" ) )
        return PLUGIN_CONTINUE;

    sc_remove_data( id );

    return PLUGIN_CONTINUE;
}

public evDeath() {

    new id = read_data(2);
    sc_remove_data( id );

    return PLUGIN_CONTINUE;
}

public plugin_init() {

    register_plugin( g_szTitle, g_szVersion, g_szAuthor );

    // set defaults ( for non 'sniper_control.cfg' users )

    register_cvar( "mp_sniper_control", "1" );
    register_cvar( "sc_max_snipers_t",  "2" );
    register_cvar( "sc_max_snipers_ct", "2" );

    // Standard Menus

    register_menucmd( register_menuid("BuyRifle" , 1 ), (1<<4), "menuSniper" );        //  T: AWP, CT: Sig SG-550 Sniper
    register_menucmd( register_menuid("BuyRifle" , 1 ), (1<<5), "menuSniper" );        // CT: AWP,  T: H&K G3/SG-1 Sniper Rifle


	// Block Aliases and Vgui menus - because steam sucks and uses aliases to buy rifles ?!?!?

    register_clcmd("awp",      "menuSniper");
    register_clcmd("magnum",   "menuSniper");
    register_clcmd("g3sg1",    "menuSniper");
    register_clcmd("d3au1",    "menuSniper");
    register_clcmd("sg550",    "menuSniper");
    register_clcmd("krieg550", "menuSniper");

    register_menucmd( -31 ,(1<<4), "menuSniper" );                                     //  T: AWP, CT: Sig SG-550 Sniper        - VGUI
    register_menucmd( -31 ,(1<<5), "menuSniper" );                                     // CT: AWP,  T: H&K G3/SG-1 Sniper Rifle - VGUI

    #if ( INCLUDE_SCOUT )

    register_menucmd( register_menuid("BuyRifle" , 1 ), (1<<1), "menuSniper" );        // CT: Scout - Standard
    register_menucmd( register_menuid("BuyRifle" , 1 ), (1<<2), "menuSniper" );        //  T: Scout - Standard

    register_clcmd("scout",    "menuSniper");

    register_menucmd( -31 ,(1<<1), "menuSniper" );                                     // CT: Scout - VGUI
    register_menucmd( -31 ,(1<<2), "menuSniper" );                                     //  T: Scout - VGUI

    #endif

    register_event( "WeapPickup", "evPickUp",       "b"                         );        // 3 = Scout, 13 = SG-550, 18 = AWP, G3/SG-1
    register_clcmd( "drop",       "cmdDrop"                                     );
    register_event( "DeathMsg",   "evDeath",        "a"                         );
    register_event( "TextMsg",    "evRestartRound", "a", "2&Game_C", "2&Game_w" );

    if ( !Map_Disabled() )
    {
        new szConfigFile[64];
        get_configsdir( szConfigFile, 63 );
        format( szConfigFile, 63, "%s/sniper_control.cfg", szConfigFile );
        server_cmd( "exec %s", szConfigFile );                                                // load configuration settings
    }
    else
    {
        set_cvar_num( "mp_sniper_control", 0 );
    }

    return PLUGIN_CONTINUE;
}