<?php
/*
 *	Corllete Lab Theme - Stream
 *
 * Copyright (C) 2006-2009 Corllete ltd (clabteam.com)
 * Support and updates at http://www.free-source.net/
 * Released under the terms and conditions of the
 * Creative common license (http://creativecommons.org/licenses/by-nc/3.0/)
 *
 * Free Theme Stream - theme.php
 *
 * $Id: theme.php 312 2009-07-30 09:27:46Z sonice $
*/
if (!defined('e107_INIT')) { exit; }

// [multilanguage]
include_lan(THEME."languages/".e_LANGUAGE.".php");

$themename = "Stream";
$themeversion = "1.0<br/>07/2009";
$themeauthor = "Corllete Lab";
$themeemail = "support@free-source.net";
$themewebsite = "http://free-source.net";
$themedate = "Created: 07/2009";
$themeinfo = '
<h3>LICENSE</h3>
<a href="http://topshablons.ru/e107" title="Creative Commons Licence"><img src="http://i.creativecommons.org/l/by-nc/2.5/bg/88x31.png" style="float: left; margin-right: 10px;" alt="" /></a>
<a href="http://wlna.info" title="Creative Commons Licence">Creative Commons Licence</a>
This theme is free for use, but if you decide to use this theme you must keep the link {image or text-link} to <strong>FREE-SOURCE.NET</strong> on the bottom of the page. Please respect our work. For using this theme without a link to us please contact our team.
<br/><br/>
<h3>REDISTRIBUTION</h3>
You are <strong>NOT ALLOWED</strong> to redistribute this theme as a package on your site. We need to keep all versions of this theme on one place - FreeSource.net.
Please contact us and ask for permissions first.
';

$xhtmlcompliant = TRUE;
$csscompliant = TRUE;
define("STANDARDS_MODE", TRUE);
define("NEXTPREV_NOSTYLE", "1");
define("IMODE", "lite");
define("USER_WIDTH","width:100%");

// FS CUSTOM SORTCODES
$register_sc[]='FS_SITELINKS';
$register_sc[]='FS_CUSTOM';

//	FS SITELINKS SETTINGS
define("FS_LINK_SEPARATOR",'<!-- -->');
define("FS_START_SEPARATOR", FALSE);
define("FS_END_SEPARATOR", FALSE);


/* CL WIDGETS */
$theme_stream = null;

$area_1 = true;
$area_2 = true;

if(class_exists('clw_widget'))
{
	/** CL WIDGETS **/
	$cl_widgets = &clw_widget::getInstance();
	$theme_stream = $cl_widgets->getWidget('theme_stream');
	if ($theme_stream) {
		if ( e_PAGE != "menus.php" ) {
			if ($theme_stream->streamCheckMenu(1)) {
				$area_1 = true;
			} else {
				$area_1 = false;
			}
			
			if ($theme_stream->streamCheckMenu(2)) {
				$area_2 = true;
			} else {
				$area_2 = false;
			}
			/**/
		}
	}
} 

if (!$theme_stream){
	/* do something */
}

function theme_head() {
	global $area_1, $area_2;
	return '
		<!--[if lte IE 7]>
		<script type="text/javascript" src="'.THEME_ABS.'menu/menu.js"></script>
		<style type="text/css">
			.main-left {filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'.THEME_ABS.'images/f02_main_left.png",sizingMethod="crop"); background: none;}
			.main-right {filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'.THEME_ABS.'images/f02_main_right.png",sizingMethod="crop"); background: none;}
			.main-center {filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'.THEME_ABS.'images/f02_main_center.png",sizingMethod="crop"); background: none;}
			.box-left {filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'.THEME_ABS.'images/f02_box_left-TL.png",sizingMethod="crop"); background: none;}
			.box-right {filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'.THEME_ABS.'images/f02_box_left-TR.png",sizingMethod="crop"); background: none;}

			.box-white .TL {filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'.THEME_ABS.'images/f02_box_white-TL.png",sizingMethod="crop"); background: none;}
			.box-white .TR {filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'.THEME_ABS.'images/f02_box_white-TR.png",sizingMethod="crop"); background: none;}
			.box-white .BL {filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'.THEME_ABS.'images/f02_box_white-BL.png",sizingMethod="crop"); background: none;}
			.box-white .BR {filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'.THEME_ABS.'images/f02_box_white-BR.png",sizingMethod="crop"); background: none;}
		</style>
		<![endif]-->
		<link rel="stylesheet" href="'.THEME_ABS.'menu/menu.css" type="text/css" media="all" />
		<style type="text/css">
			'.(( e_PAGE == "menus.php" ) ? 'body { background-color: #fff}' : '/* */').'
		</style>
	';
}


//TABLERENDER
function tablestyle($caption, $text, $mode) {
	global $style;
	if (!USER && $mode == 'login') { return; }
	switch($style) {
		case "col_left":
			echo '
				<h3>'.$caption.'</h3>
				<div class="sep-01"><div class="sep-01-TC"><div class="sep-01-TR"><!-- --></div></div></div>
				'.$text.'
				<div class="H20"></div>
			';
			break;
		case "col_right":
			echo '
				<div class="box-white">
					<div class="TL f-left"><!-- --></div>
					<div class="TR f-right"><!-- --></div>
					<div class="TC"><!-- --></div>
					<div class="ML"><div class="MR">
						<div class="content">
							<h3>'.$caption.'</h3>
							<div class="sep-01"><div class="sep-01-TC"><div class="sep-01-TR"><!-- --></div></div></div>
							'.$text.'
							<div class="H20"></div>
						</div>
					</div></div>
					<div class="BL f-left"><!-- --></div>
					<div class="BR f-right"><!-- --></div>
					<div class="BC"><!-- --></div>
				</div>
				<div class="clear H20"><!-- --></div>
			';
			break;
		case "center":
			echo '
				<div class="box-white">
					<div class="TL f-left"><!-- --></div>
					<div class="TR f-right"><!-- --></div>
					<div class="TC"><!-- --></div>
					<div class="ML"><div class="MR">
						<div class="content">
							<h3>'.$caption.'</h3>
							<div class="sep-01" style="width: 95%"><div class="sep-01-TC"><div class="sep-01-TR"><!-- --></div></div></div>
							'.$text.'
							<div class="H20"></div>
						</div>
					</div></div>
					<div class="BL f-left"><!-- --></div>
					<div class="BR f-right"><!-- --></div>
					<div class="BC"><!-- --></div>
				</div>
				<div class="clear H20"><!-- --></div>
			';
			break;
		default:
			echo '
				<h3>'.$caption.'</h3>
				'.$text.'
			';
		break;
	}
}

function linkstyle($linkstyle) {
	switch($linkstyle) {
		case "bottom_links_left":
			$style['prelink'] = '<ul id="bottom-links">';
			$style['postlink'] = '</ul>';
			$style['linkstart'] = '<li>';
			$style['linkend'] = '</li>';
			$style['linkdisplay'] = '1';
			$style['linkalign'] = '';
			$style['linkclass'] = '';
			$style['linkstart_hilite'] = '';
			$style['linkseparator'] = '<li>| </li>';
			$style['linkmainonly'] = true;
			break;
	}
	return $style;
}

// Custom search template for { SEARCH } shortcode
$SEARCH_SHORTCODE = '
	<img src="'.THEME_ABS.'images/1008_search_ico.png" alt="" />
	<input class="custom-search" type="text" name="q" size="25" maxlength="50" value="'.LAN_SEARCH.' ..." onfocus="if (this.value == \''.LAN_SEARCH.' ...\') this.value = \'\'; " onblur="if (this.value == \'\') this.value = \''.LAN_SEARCH.' ...\';" />
	<input class="custom-button" type="submit" name="s" value="'.LAN_180.'&nbsp;&raquo;" />

';

$HEADER = '
<table cellpadding="0" cellspacing="0" style="border: 0px none; width: 100%;">
	<tr>
		<td style="width: 100%; vertical-align: top"> 
			<div class="body-wrapper">
				<div class="header-wrapper">
					<div class="view-area">
						<div class="banner">
							{BANNER}
						</div>
						<img src="'.THEME_ABS.'images/logo.jpg" alt="{SITENAME}" style="vertical-align: top" />
					</div>
				</div>
				<div class="navbar-wrapper">
					<div class="view-area">
						{FS_SITELINKS}
					</div>
				</div>
				<div class="content-wrapper">
					<div class="view-area">
						<div class="main-left f-left"><!-- --></div>
						<div class="main-right f-right"><!-- --></div>
						<div class="main-center">
							'.(($area_1) ? '
							<div class="col-left f-left">
								<div class="box-left f-left"><div class="bkg-white"><!-- --></div></div>
								<div class="box-right f-right"><div class="bkg-white"><!-- --></div></div>
								<div class="box-center">
									<div class="box-content">
										{SETSTYLE=col_left}
										{MENU=1}
									</div>
								</div>
							</div>
							' : '').'
							<div class="col-main-center">
								<div style="height: 67px; padding: 0px 20px;">
									<div class="search-wrapper">
										{SEARCH}
									</div>
									<div class="custom-login-wrapper">
										'.((!USER) ? '{FS_CUSTOM=login}' : '' ).'
									</div>
								</div>
								<div class="H20"><!-- --></div>
								'.(($area_2) ? '
								<div class="col-right f-right">
									{SETSTYLE=col_right}
									{MENU=2}
								</div>
								' : '').'
								<div class="col-center">
									{SETSTYLE=center}
';

$FOOTER = '					
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="footer-wrapper">
					<div class="box-foot">
						<div class="TC"><div class="TL"><div class="TR">
							<div class="foot-cont">
								<div class="f-right">
									<a href="http://validator.w3.org/check?uri=referer">
										<img src="'.THEME.'images/free-source_bottom_xhtml.png" alt="XHTML 1.1" style="border: 0px none;" />
									</a>&nbsp;&nbsp;&nbsp;
									<a href="http://topshablons.ru/e107"><img src="'.THEME.'images/free-source_bottom.png" alt="Free-Source.net" /></a> <div style="display:none;">  <a href="http://topshablons.ru/e107">  e107</a></div> <div style="display:none;"><a href="http://wlna.info" title=" "> </a>.</div><div style="display:none;"> <a href="http://opolicii.ru/" title=""></a> </div>

								</div>
								<div class="left">
									{LINKSTYLE=bottom_links_left}
									{SITELINKS=flat:2}
								</div>
								<div class="clear H30"><!-- --></div>
								<div class="center">{SITEDISCLAIMER}</div>
							</div>
						</div></div></div>
					</div>
				</div>
			</div>
		</td>
	</tr>
</table>
';

define('COMMENTLINK', LAN_THEME_2);
define('COMMENTOFFSTRING', '');
define('PRE_EXTENDEDSTRING', '<div class="right extended">');
define('EXTENDEDSTRING', LAN_THEME_3);
define('POST_EXTENDEDSTRING', '</div>');
define('TRACKBACKSTRING', '');
define('TRACKBACKBEFORESTRING', '');


$sc_style['NEWSIMAGE']['pre'] = '<div class="f-left MR20">';
$sc_style['NEWSIMAGE']['post'] = '</div>';
$sc_style['NEWSICON']['pre'] = '<div class="f-left" style="margin-right: 10px;">';
$sc_style['NEWSICON']['post'] = '</div>';
$sc_style['STICKY_ICON']['pre'] = '<span class="f-left" style="margin-right: 15px; margin-bottom: 5px">';
$sc_style['STICKY_ICON']['post'] = '</span>';
$sc_style['NEWSCOMMENTS']['pre'] = '<img class="MR5" src="'.THEME_ABS.'images/f02_comments.png" alt="" />';
$sc_style['NEWSCOMMENTS']['post'] = '';

function news_style($news) {
	global $sc_style;
	//print_r($news);
	if ($news['news_thumbnail'] && $news['news_thumbnail'] != '' ) {
		$thumb_src_path = e_IMAGE.'newspost_images/thumb_'.$news['news_thumbnail'];
		$thumb_src_path_abs = e_IMAGE_ABS.'newspost_images/thumb_'.$news['news_thumbnail'];
		$image_src_path = e_IMAGE.'newspost_images/'.$news['news_thumbnail'];
		$image_src_path_abs = e_IMAGE_ABS.'newspost_images/'.$news['news_thumbnail'];
		
		
		if (file_exists($thumb_src_path)) { 
			$image = $sc_style['NEWSIMAGE']['pre'].'<a href="'.$image_src_path_abs.'" rel="shadowbox" title="'.$news['news_title'].'"><img src="'.$thumb_src_path_abs.'" alt="" style="padding: 3px; border: 1px solid #C9DDEC;" /></a>'.$sc_style['NEWSIMAGE']['post'];
		} else {
			$image = $sc_style['NEWSIMAGE']['pre'].'<img src="'.$image_src_path_abs.'" alt="" style="padding: 3px; border: 1px solid #C9DDEC;" />'.$sc_style['NEWSIMAGE']['post']; 
		}
	}

	$NEWSSTYLE = '
		<div class="box-white">
			<div class="TL f-left"><!-- --></div>
			<div class="TR f-right"><!-- --></div>
			<div class="TC"><!-- --></div>
			<div class="ML"><div class="MR">
				<div class="content">
					<div class="caption-padding">
						<img class="f-left" src="'.THEME_ABS.'images/f02_bullet-01.png" alt="{NEWSTITLE}" />
						<h2 class="news-title">{NEWSTITLE}</h2>
						<div class="news-date">'.LAN_THEME_5.'{NEWSAUTHOR} '.LAN_THEME_6.'{NEWSDATE=short}</div>
					</div>
					<div class="H20"><!-- --></div>
					'.$image.'
					{NEWSBODY}
					<div class="H30"><!-- --></div>
					{EXTENDED}
					<div class="H15"><!-- --></div>
					<div class="options">
						<div class="f-right">{ADMINOPTIONS}{EMAILICON}{PRINTICON}{PDFICON}</div>
						{NEWSCOMMENTS}
					</div>
				</div>
			</div></div>
			<div class="BL f-left"><!-- --></div>
			<div class="BR f-right"><!-- --></div>
			<div class="BC"><!-- --></div>
		</div>
		<div class="H20"><!-- --></div>
		<div class="H20"><!-- --></div>
		
	';
	
	return $NEWSSTYLE;
}


define("NEWSCAT_CATLINK","");
define("NEWSCAT_ITEMLINK","");
define("NEWSCAT_STYLE","width:100%");
define("NEWSCAT_CATICON","border:0px; margin-right: 10px;");
define("NEWSCAT_THUMB","border:0px");
define("NEWSCAT_CELL","vertical-align:top");

$sc_style['NEWSSUMMARY']['pre'] = '<br/>';
$sc_style['NEWSSUMMARY']['post'] = '';

// the style of the items in news.php?cat and news.php?all
$NEWSLISTSTYLE = '
	<div style="margin-bottom: 15px;">
		<img src="'.THEME.'images/bullet2.gif" alt="" style="vertical-align: middle" />{NEWSTITLELINK}<br/>
		{NEWSDATE}{NEWSSUMMARY}
	</div>
';

//Render news categories on the bottom of the page
$NEWSCAT = '
	<div class="left">
		<table cellpadding="0" cellspacing="0" style="width: 100%">
			<tr>
				<td class="left v-top" style="width: 10%">{NEWSCATICON}</td>
				<td class="left v-middle">
					<h4 class="news-title-cat">{NEWSCATEGORY}</h4>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="v-top left" style="padding-top: 10px;">
					<table style="width: 100%" cellpadding="0" cellspacing="0">
						{NEWSCAT_ITEM}
					</table>
				</td>
			</tr>
		</table>	
	<div class="dummyH20"><!-- --></div>
	</div>
	
';

//Loop for news items in category
$NEWSCAT_ITEM = '
				<tr>
					<td class="catlink left v-middle" style="padding-bottom: 5px; padding-left: 30px;">
						<img src="'.THEME.'images/bullet2.gif" alt="" />&nbsp;{NEWSTITLELINK}
					</td>
				</tr>
';

?>